/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.ValuedComposite;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class Variant
extends ValuedComposite<Variant>
implements ComponentFactory<Variant> {
    public Variant() {
    }

    public Variant(EditionComponent<?> parent) {
        super(parent);
    }

    public Variant(Element element) {
        super(element);
    }

    public VariantItem getBasicTextVariantItem() {
        return this.getFirstNodeByType(new VariantItem());
    }

    private VariantItem getOrCreateBasicTextVariantItem() {
        return this.getFirstOrAppendNodeByType(new VariantItem());
    }

    public List<VariantItem> getVariantItems() {
        return this.getNodesByType(new VariantItem());
    }

    @Override
    public List<EditionComponent<?>> getContents() {
        VariantItem variant_item = this.getBasicTextVariantItem();
        Reading reading = variant_item.getReading();
        Content content = reading.getFirstNodeByType(new Content());
        return content.getChildren();
    }

    @Override
    public void addContent(EditionComponent<?> component) {
        VariantItem variant_item = this.getOrCreateBasicTextVariantItem();
        Reading reading = variant_item.getReading();
        Content content = reading.getFirstOrAppendNodeByType(new Content(this));
        content.addChild(component);
    }

    @Override
    public void setContent(EditionComponent<?> component) {
        VariantItem variant_item = this.getOrCreateBasicTextVariantItem();
        Reading reading = variant_item.getReading();
        Content content = reading.getFirstOrAppendNodeByType(new Content(this));
        content.removeAllChildren();
        content.addChild(component);
    }

    @Override
    public void setValue(String value) {
        VariantItem variant_item = this.getOrCreateBasicTextVariantItem();
        variant_item.setReadingValue(value);
    }

    @Override
    public String getValue() {
        return this.getBasicTextVariantItem().getReadingValue();
    }

    @Override
    public String toString() {
        String retVal = "";
        List<VariantItem> items = this.getVariantItems();
        if (items.size() > 0) {
            retVal = String.valueOf(retVal) + items.get(0).toString();
            int i = 1;
            while (i < items.size()) {
                retVal = String.valueOf(retVal) + " " + items.get(i).toString();
                ++i;
            }
        }
        return retVal;
    }

    @Override
    public List<EditionComponent<?>> getChildrenForTextView() {
        ArrayList nodes = new ArrayList();
        VariantItem first_variant_item = this.getBasicTextVariantItem();
        if (first_variant_item != null) {
            nodes.add(first_variant_item);
        }
        return nodes;
    }

    public boolean referOntology(OntologyClass ontology_class) {
        boolean refer = false;
        for (VariantItem item : this.getVariantItems()) {
            refer = item.referOntology(ontology_class);
            if (refer) break;
        }
        return refer;
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Deprecated
    public Variant make(Element element) {
        return new Variant(element);
    }

    @Override
    public String getElementName() {
        return "variant";
    }
}

