/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.ImpossibleSplitException;
import org.homelinux.elabor.scriptorium.ecomponents.ValuedLeaf;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Text
extends ValuedLeaf<Text>
implements ComponentFactory<Text> {
    public Text() {
    }

    public Text(Element element) {
        super(element);
    }

    public Text(EditionComponent<?> parent) {
        super(parent);
    }

    public void insertString(int offset, String string) {
        StringBuffer text = new StringBuffer(this.getValue());
        text.insert(offset, string);
        this.setValue(text.toString());
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public int getTextLength() {
        return this.getValue().length();
    }

    public List<Text> getSplittedText(int offset, int length) throws ImpossibleSplitException {
        Document document = this.getElement().getOwnerDocument();
        Text before = new Text(document.createElement("text"));
        Text current = new Text(document.createElement("text"));
        Text after = new Text(document.createElement("text"));
        String old_text = this.getValue();
        try {
            before.setValue(old_text.substring(0, offset));
            current.setValue(old_text.substring(offset, offset + length));
            after.setValue(old_text.substring(offset + length));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ImpossibleSplitException(e);
        }
        ArrayList<Text> splitted_text = new ArrayList<Text>();
        splitted_text.add(before);
        splitted_text.add(current);
        splitted_text.add(after);
        return splitted_text;
    }

    @Override
    protected boolean collapse(EditionComponent<?> sibling) {
        Text text_sibling;
        String text_sibling_value;
        boolean collapsed = false;
        if (sibling instanceof Text && (text_sibling_value = (text_sibling = (Text)sibling).getValue()).length() > 0) {
            String content = String.valueOf(this.getValue()) + text_sibling_value;
            this.setValue(content);
            text_sibling.setValue("");
            collapsed = true;
        }
        return collapsed;
    }

    @Override
    public void normalize() {
        EditionComposite<Text> parent;
        if (this.getValue().length() == 0 && (parent = this.getParent()) != null) {
            parent.removeChild(this);
        }
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Text make(Element element) {
        return new Text(element);
    }

    @Override
    public String getElementName() {
        return "text";
    }
}

