/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Ontology {
    Document document;

    public Ontology(URL ontologyURL) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setValidating(false);
        try {
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            try {
                this.document = builder.parse(ontologyURL.toString());
            }
            catch (IOException exc) {
                this.document = builder.newDocument();
            }
        }
        catch (ParserConfigurationException | SAXException exc) {
            throw new RuntimeException(exc);
        }
    }

    public List<OntologyClass> getClasses() {
        ArrayList<OntologyClass> classes = new ArrayList<OntologyClass>();
        ArrayList<String> superIds = new ArrayList<String>();
        Node child = this.document.getDocumentElement().getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                String orderString;
                Element element = (Element)child;
                String classId = element.getAttribute("rdf:ID");
                String classComment = Ontology.getClassComment(element);
                int index = classComment.indexOf(124);
                if (index >= 0) {
                    orderString = String.valueOf(classComment.substring(index + 1)) + ", " + classComment.substring(0, index);
                    classComment = classComment.replace('|', ' ');
                } else {
                    orderString = classComment;
                }
                if (classId != null && classId.length() > 0) {
                    OntologyClass ontyologyClass = new OntologyClass(classId, classComment, orderString);
                    classes.add(ontyologyClass);
                    String superId = Ontology.getClassSuperId(element);
                    superIds.add(superId);
                }
            }
            child = child.getNextSibling();
        }
        int index = 0;
        while (index < classes.size()) {
            OntologyClass superClass;
            String id = (String)superIds.get(index);
            if (id != null && (superClass = Ontology.getOntologyClass(id, classes)) != null) {
                OntologyClass ontologyClass = (OntologyClass)classes.get(index);
                ontologyClass.setSuperClass(superClass);
            }
            ++index;
        }
        return classes;
    }

    private static String getClassSuperId(Element element) {
        String value = null;
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("rdfs:subClassOf")) {
                Element childElement = (Element)child;
                value = childElement.getAttribute("rdf:resource");
            }
            child = child.getNextSibling();
        }
        return value;
    }

    private static String getClassComment(Element element) {
        return Ontology.getElementValue(element, "rdfs:comment");
    }

    private static String getElementValue(Element element, String elName) {
        String value = "";
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals(elName)) {
                value = String.valueOf(value) + ((Element)child).getTextContent();
            }
            child = child.getNextSibling();
        }
        return value;
    }

    public OntologyClass getOntologyClass(OntologyReferenceInterface reference) {
        String ontologyId = reference.getOntologyId();
        OntologyClass ontologyClass = this.getOntologyClassById(ontologyId);
        return ontologyClass;
    }

    public OntologyClass getOntologyClassById(String id) {
        List<OntologyClass> classes = this.getClasses();
        return Ontology.getOntologyClass(id, classes);
    }

    private static OntologyClass getOntologyClass(String id, List<OntologyClass> classes) {
        OntologyClass result = null;
        for (OntologyClass current : classes) {
            if (!current.getId().equals(id)) continue;
            result = current;
            break;
        }
        return result;
    }

    public OntologyClass getOntologyClassByComment(String comment) {
        OntologyClass result = null;
        for (OntologyClass current : this.getClasses()) {
            if (!current.getComment().equals(comment)) continue;
            result = current;
            break;
        }
        return result;
    }

    public List<OntologyClass> getChildren(OntologyClass parent) {
        ArrayList<OntologyClass> children = new ArrayList<OntologyClass>();
        String parentId = parent.getId();
        List<OntologyClass> classes = this.getClasses();
        for (OntologyClass ontologyClass : classes) {
            String superClassId;
            OntologyClass superClass = ontologyClass.getSuperClass();
            if (superClass == null || !(superClassId = superClass.getId()).equals(parentId)) continue;
            children.add(ontologyClass);
        }
        return children;
    }

    public List<OntologyClass> getClassTypes() {
        ArrayList<OntologyClass> classTypes = new ArrayList<OntologyClass>();
        List<OntologyClass> classes = this.getClasses();
        for (OntologyClass ontologyClass : classes) {
            OntologyClass superClass = ontologyClass.getSuperClass();
            if (superClass != null) continue;
            classTypes.add(ontologyClass);
        }
        return classTypes;
    }
}

