/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.iterators.EditionIterator;
import org.homelinux.elabor.scriptorium.ecomponents.iterators.TextViewIterator;
import org.homelinux.elabor.scriptorium.ecomponents.undo.ChangeStringAttributeEffect;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitable;
import org.homelinux.elabor.tools.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EditionComponent<T extends EditionComponent<T>>
implements EditionVisitable,
Iterable<EditionComponent<?>> {
    public static final String CITATION = "citation";
    public static final String COMMENT = "comment";
    public static final String CONSPECTUS = "conspectus";
    public static final String CONTENT = "content";
    public static final String DESCRIPTION = "description";
    public static final String DESCRIPTION_ITEM = "descriptionitem";
    public static final String DRAWING = "drawing";
    public static final String EDITION = "edition";
    public static final String ENUNCIATIO = "enunciatio";
    public static final String EXPUNCTIO = "expunctio";
    public static final String CRUX = "crux";
    public static final String FORMULA = "math";
    public static final String PLACE = "place";
    public static final String WORK = "work";
    public static final String HEADER = "header";
    public static final String INTEGRATIO = "integratio";
    public static final String FOLIUM = "folium";
    public static final String NAME = "name";
    public static final String MATHCONCEPT = "mathconcept";
    public static final String DATE_TOKEN = "date_token";
    public static final String ONTOLOGY_REFERENCE = "ontologyreference";
    public static final String READING = "reading";
    public static final String READING_REFERENCE = "readingreference";
    public static final String QDR = "qdr";
    public static final String RTT = "rtt";
    public static final String TEXT = "text";
    public static final String UNIT = "unit";
    public static final String LIST_ITEM = "listitem";
    public static final String VARIANT = "variant";
    public static final String VARIANT_ITEM = "variantitem";
    public static final String WITNESS = "witness";
    public static final String WITNESS_ID = "id";
    public static final String WITNESSES_IDS = "ids";
    public static final String REFERENCES = "references";
    public static final String REFERENCE = "reference";
    public static final String TITLE = "title";
    public static final String IDENTIFIER = "identifier";
    public static final String AUTHOR = "sender";
    public static final String AUTHOR_PLACE = "sender_place";
    public static final String RECEIVER = "receiver";
    public static final String RECEIVER_PLACE = "receiver_place";
    public static final String EDITION_DATE = "date";
    public static final String PUBLICATION = "publication";
    public static final String ANNOTATION = "annotation";
    public static final String STYLE = "style";
    public static final String STYLESET = "styleset";
    public static final String RELEASE = "release";
    public static final String GLYPHGROUP = "glyphgroup";
    public static final String TEXT_PART = "part";
    public static final String TONGUE = "tongue";
    public static final String IMAGE = "image";
    public static final String CHOSEN = "chosen";
    private Element element = null;
    private EditionListener listener;

    public abstract String getElementName();

    public EditionComponent() {
    }

    public EditionComponent(Element element) {
        this.setElement(element);
    }

    public EditionComponent(EditionComponent<?> parent) {
        Element parentElement = parent.getElement();
        Document ownerDocument = parentElement.getOwnerDocument();
        this.createElement(ownerDocument);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object instanceof EditionComponent) {
            EditionComponent component = (EditionComponent)object;
            result = this.getElement() == component.getElement();
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.getElement().hashCode();
    }

    public T makeCopy(T component) {
        Element clone = (Element)this.element.cloneNode(true);
        ((EditionComponent)component).setElement(clone);
        return component;
    }

    protected void createElement(Document document) {
        Element newElement = document.createElement(this.getElementName());
        this.setElement(newElement);
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public Document getDocument() {
        Document document = null;
        if (this.getElement() != null) {
            document = this.element.getOwnerDocument();
        }
        return document;
    }

    public Edition getEdition() {
        Edition edition;
        Document document = this.getDocument();
        if (document == null) {
            edition = null;
        } else {
            Element documentElement = document.getDocumentElement();
            edition = new Edition(documentElement);
        }
        return edition;
    }

    public void removeAttribute(String name) {
        this.getElement().removeAttribute(name);
    }

    public void setStringAttribute(String name, String value) {
        this.setStringAttribute(name, value, true);
    }

    public void setStringAttribute(String name, String value, boolean notify) {
        String oldValue;
        Attr attribute = this.element.getAttributeNode(name);
        String string = oldValue = attribute == null ? null : this.getStringAttribute(name);
        if (!value.equals(oldValue)) {
            this.element.setAttribute(name, value);
            UndoableEdit undoEdit = notify ? EditionComponent.createUndo(this, name, oldValue, value) : null;
            this.valueChanged(undoEdit);
        }
    }

    private static <Q extends EditionComponent<Q>> UndoableEdit createUndo(EditionComponent<Q> component, String name, String oldValue, String value) {
        return new ChangeStringAttributeEffect(component, name, oldValue, value);
    }

    public String getStringAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public void setDoubleAttribute(String name, double value) {
        this.setStringAttribute(name, String.valueOf(value));
    }

    public double getDoubleAttribute(String name) {
        double ret_value;
        try {
            String attribute = this.getElement().getAttribute(name);
            ret_value = Double.parseDouble(attribute);
        }
        catch (NumberFormatException exc) {
            ret_value = 0.0;
        }
        return ret_value;
    }

    public void setFloatAttribute(String name, float value) {
        float fixedValue = (double)Math.abs(value) < 1.0E-8 ? 0.0f : value;
        this.setStringAttribute(name, String.valueOf(fixedValue));
    }

    public void setEnumAttribute(String name, Enum<?> value) {
        this.setStringAttribute(name, value.name());
    }

    public <E extends Enum<E>> E getEnumAttribute(String name, Class<E> enumType, E defaultValue) {
        E value;
        try {
            value = this.getEnumAttribute(name, enumType);
        }
        catch (RuntimeException exc) {
            value = defaultValue;
        }
        return value;
    }

    public <E extends Enum<E>> E getEnumAttribute(String name, Class<E> enumType) {
        String value = this.getStringAttribute(name);
        return Enum.valueOf(enumType, value);
    }

    public float getFloatAttribute(String name) {
        return this.getFloatAttribute(name, 0.0f);
    }

    public float getFloatAttribute(String name, float defaultValue) {
        float ret_value;
        try {
            String attribute = this.getElement().getAttribute(name);
            ret_value = Float.parseFloat(attribute);
        }
        catch (NumberFormatException exc) {
            ret_value = defaultValue;
        }
        return ret_value;
    }

    public void setIntAttribute(String name, int value) {
        this.setStringAttribute(name, String.valueOf(value));
    }

    public int getIntAttribute(String name) {
        int value;
        try {
            String attribute = this.getElement().getAttribute(name);
            value = Integer.parseInt(attribute);
        }
        catch (NumberFormatException exc) {
            value = 0;
        }
        return value;
    }

    public void setColorAttribute(String name, Color color, boolean original) {
        String red = String.valueOf(color.getRed());
        String green = String.valueOf(color.getGreen());
        String blue = String.valueOf(color.getBlue());
        String alpha = String.valueOf(color.getAlpha());
        String colorString = String.valueOf(red) + ":" + green + ":" + blue + ":" + alpha;
        String colorName = String.valueOf(name) + (original ? "_orig" : "");
        this.setStringAttribute(colorName, colorString);
    }

    public Color getColorAttribute(String name, boolean original) {
        Color color;
        String attribute = this.element.getAttribute(String.valueOf(name) + (original ? "_orig" : ""));
        if (StringUtils.isEmpty(attribute)) {
            attribute = this.element.getAttribute(name);
        }
        if (attribute.isEmpty()) {
            color = null;
        } else {
            String[] components = attribute.split(":", 4);
            int red = Integer.parseInt(components[0]);
            int green = Integer.parseInt(components[1]);
            int blue = Integer.parseInt(components[2]);
            int alpha = components.length == 4 ? Integer.parseInt(components[3]) : 255;
            color = new Color(red, green, blue, alpha);
        }
        return color;
    }

    public void setBooleanAttribute(String name, boolean value) {
        this.setStringAttribute(name, String.valueOf(value));
    }

    public boolean getBooleanAttribute(String name, boolean defaultvalue) {
        String attribute = this.getElement().getAttribute(name);
        boolean result = attribute.length() > 0 ? Boolean.parseBoolean(attribute) : defaultvalue;
        return result;
    }

    protected <eN> List<eN> getNodesByType(ComponentFactory<eN> factory) {
        ArrayList<eN> components = new ArrayList<eN>();
        for (EditionComponent<?> child : this.getChildren()) {
            String factoryElementName;
            String elementName = child.getElementName();
            if (elementName.equals(factoryElementName = factory.getElementName())) {
                Element childElement = child.getElement();
                eN component = factory.make(childElement, this.listener);
                components.add(component);
            }
            List<eN> list = child.getNodesByType(factory);
            components.addAll(list);
        }
        return components;
    }

    public List<EditionComponent<?>> getChildren() {
        return new ArrayList();
    }

    public List<EditionComponent<?>> getChildrenForTextView() {
        return this.getChildren();
    }

    public EditionComposite<?> getParent() {
        EditionComposite parent = null;
        Node parentNode = this.element.getParentNode();
        if (parentNode instanceof Element) {
            Element parentElement = (Element)parentNode;
            parent = (EditionComposite)EditionComponentFactory.createEditionElement(parentElement, this.getListener());
        }
        return parent;
    }

    protected int index() {
        int index = -1;
        EditionComposite<?> parent = this.getParent();
        for (EditionComponent<?> child : parent.getChildren()) {
            ++index;
            if (this.equals(child)) break;
        }
        return index;
    }

    public EditionComponent<?> getNextComponent() {
        int index = this.index() + 1;
        EditionComposite<?> parent = this.getParent();
        List<EditionComponent<?>> siblings = parent.getChildren();
        return siblings.size() > index ? siblings.get(index) : null;
    }

    public int getTextLength() {
        int length = 0;
        for (EditionComponent<?> child : new TextViewIterator(this)) {
            length += child.getTextLength();
        }
        return length;
    }

    public abstract boolean contains(EditionComponent<?> var1);

    protected boolean collapse(EditionComponent<?> sibling) {
        return false;
    }

    public abstract void normalize();

    public abstract void relativize(File var1, File var2);

    @Override
    public Iterator<EditionComponent<?>> iterator() {
        return new EditionIterator(this);
    }

    protected void initialise() {
    }

    protected abstract T make(Element var1);

    public T make(Element componentElement, EditionListener scriptoriumListener) {
        T item = this.make(componentElement);
        ((EditionComponent)item).setListener(scriptoriumListener);
        return item;
    }

    public void setListener(EditionListener listener) {
        this.listener = listener;
    }

    public EditionListener getListener() {
        return this.listener;
    }

    protected void valueChanged(UndoableEdit undoEdit) {
        if (this.listener != null) {
            this.listener.editionChanged(undoEdit);
        }
    }

    public EditionComponent<T> getComponent() {
        return this;
    }
}

