/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db.time;

import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.time.TimeDao;
import org.homelinux.elabor.db.time.TimeRecord;
import org.homelinux.elabor.exceptions.UnrecoverableException;

public class TimeDbHelper<K, T extends TimeRecord<K>> {
    private static final Date END_OF_TIME = CalendarTools.getEndOfTime();
    private TimeDao<K, T> dao;

    public TimeDbHelper(TimeDao<K, T> dao) {
        this.dao = dao;
    }

    public void save(T record) throws UnrecoverableException {
        Object key = record.getKey();
        Date changeDate = record.getStartDate();
        try {
            this.save(record, key, changeDate);
        }
        catch (DuplicateKeyException e) {
            throw new UnrecoverableException(e);
        }
    }

    private void save(T record, K key, Date changeDate) throws DuplicateKeyException {
        try {
            TimeRecord current = (TimeRecord)this.dao.getCurrent(key, changeDate);
            Date currentStartDate = current.getStartDate();
            Date currentEndDate = current.getEndDate();
            record.setEndDate(currentEndDate);
            if (currentStartDate.equals(changeDate)) {
                this.dao.update(record);
            } else {
                current.setEndDate(changeDate);
                this.dao.update(current);
                this.dao.insert(record);
            }
        }
        catch (DataNotFoundException exc) {
            this.saveFirst(record, key, changeDate);
        }
    }

    private void saveFirst(T record, K key, Date changeDate) throws DuplicateKeyException {
        try {
            TimeRecord next = (TimeRecord)this.dao.getNext(key, changeDate);
            record.setEndDate(next.getStartDate());
        }
        catch (DataNotFoundException exc) {
            record.setEndDate(END_OF_TIME);
        }
        this.dao.insert(record);
    }

    public void delete(T record) throws UnrecoverableException {
        Object key = record.getKey();
        Date startDate = record.getStartDate();
        Date endDate = record.getEndDate();
        try {
            TimeRecord previous = (TimeRecord)this.dao.getPrevious(record);
            previous.setEndDate(endDate);
            this.dao.update(previous);
        }
        catch (DataNotFoundException previous) {
        }
        catch (DuplicateKeyException e) {
            throw new UnrecoverableException(e);
        }
        this.dao.remove(key, startDate);
    }
}

