/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.db.ConnectionHandler;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.MultiExceptionHandler;
import org.homelinux.elabor.db.MultiUpdateHandler;
import org.homelinux.elabor.db.MultipleRowException;
import org.homelinux.elabor.db.NotDeletableException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.db.StringCreator;
import org.homelinux.elabor.exceptions.UnrecoverableException;
import org.homelinux.elabor.structures.KeyRecord;
import org.homelinux.elabor.structures.classifier.RecordClassifier;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ConnectionManager
implements ConnectionHandler {
    private Connection connection;
    private String host;
    private String dbUser;
    private String dbName;
    private String dbPass;
    private DbmsType dbmsType;

    public ConnectionManager(String host, DbmsType dbmsType, String dbName, String dbUser, String dbPass, boolean connect) {
        this.host = host;
        this.dbmsType = dbmsType;
        this.dbUser = dbUser;
        this.dbName = dbName;
        this.dbPass = dbPass;
        if (connect) {
            this.initConnection();
        }
    }

    public ConnectionManager(String host, DbmsType dbmsType, String dbName, String dbUser, String dbPass) {
        this(host, dbmsType, dbName, dbUser, dbPass, true);
    }

    public ConnectionManager(DbmsType type, String dbName, String dbUser, String dbPass, boolean connect) {
        this("localhost", type, dbName, dbUser, dbPass, connect);
    }

    public ConnectionManager(DbmsType type, String dbName, String dbUser, String dbPass) {
        this("localhost", type, dbName, dbUser, dbPass);
    }

    public synchronized void initConnection() {
        if (this.connection == null) {
            try {
                this.connection = this.dbmsType.getConnection(this.host, this.dbName, this.dbUser, this.dbPass);
            }
            catch (SQLException e) {
                throw new DataAccessException(e);
            }
            catch (ClassNotFoundException e) {
                throw new DataAccessException(e);
            }
        }
    }

    public void ensureAutocommit() {
        if (this.rollback()) {
            throw new RuntimeException("database not in autocommit mode");
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    public void setTransactionIsolation(int transactionIsolation) {
        try {
            this.connection.setTransactionIsolation(transactionIsolation);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    public boolean rollback() {
        boolean rollbacked = false;
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
                rollbacked = true;
                this.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        return rollbacked;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public ResultSet executeQuery(QueryTemplate query, Statement statement) {
        String queryString = query.toString();
        return this.executeQuery(queryString, statement);
    }

    @Override
    public ResultSet executeQuery(String query, Statement statement) {
        ResultSet result;
        try {
            result = statement.executeQuery(query);
        }
        catch (SQLException e) {
            throw new DataAccessException(e, query);
        }
        return result;
    }

    public void execute(List<String> queries) {
        try {
            this.executeMultiple(queries);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void executeMultiple(List<String> queries) throws SQLException {
        boolean autoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        Savepoint savepoint = this.connection.setSavepoint();
        try (Statement statement = this.connection.createStatement();){
            for (String query : queries) {
                ConnectionManager.executeSingle(query, statement);
            }
            this.connection.commit();
        }
        catch (SQLException exc) {
            this.connection.rollback(savepoint);
            throw exc;
        }
        catch (RuntimeException exc) {
            this.connection.rollback(savepoint);
            throw exc;
        }
        finally {
            this.setAutoCommit(autoCommit);
        }
    }

    public void execute(QueryTemplate query) {
        this.execute(query.toString());
    }

    public void execute(String query) {
        try {
            this.executeSingle(query);
        }
        catch (SQLException e) {
            throw new DataAccessException(e, query);
        }
    }

    private void executeSingle(String query) throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            ConnectionManager.executeSingle(query, statement);
        }
    }

    private static void executeSingle(String query, Statement statement) {
        try {
            statement.execute(query);
        }
        catch (SQLException e) {
            throw new DataAccessException(e, query);
        }
    }

    public void executeUpdateNoControl(QueryTemplate query) {
        String queryString = query.toString();
        this.executeUpdateNoControl(queryString);
    }

    public void executeUpdateNoControl(String query) {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate(query);
        }
        catch (SQLException e) {
            throw new DataAccessException(e, query);
        }
    }

    public void executeDelete(QueryTemplate query) throws NotDeletableException {
        String queryString = query.toString();
        this.executeDelete(queryString);
    }

    public void executeDelete(String query) throws NotDeletableException {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate(query);
        }
        catch (Exception e) {
            String message = e.getMessage();
            throw new NotDeletableException(message);
        }
    }

    public void executeInsert(QueryTemplate query) throws DuplicateKeyException {
        this.executeInsert(query.toString());
    }

    public void executeInsert(String query) throws DuplicateKeyException {
        try {
            this.execute(query);
        }
        catch (DataAccessException exc) {
            Throwable cause = exc.getCause();
            String message = exc.getMessage();
            if (cause != null && (cause instanceof SQLIntegrityConstraintViolationException || message.contains("ORA-00001") || message.contains("duplicate key"))) {
                throw new DuplicateKeyException(message);
            }
            throw exc;
        }
    }

    public void executeUpdate(QueryTemplate query) throws DataNotFoundException, DuplicateKeyException {
        String string = query.toString();
        this.executeUpdate(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeUpdate(String query) throws DataNotFoundException, DuplicateKeyException {
        try (Statement statement = this.connection.createStatement();){
            int result = statement.executeUpdate(query);
            switch (result) {
                case 1: {
                    return;
                }
                case 0: {
                    throw new DataNotFoundException(query);
                }
                default: {
                    throw new DataAccessException("modificati " + result + " record per: " + query);
                }
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            throw new DuplicateKeyException(message);
        }
    }

    public boolean queryForExistence(QueryTemplate query) {
        String queryString = query.toString();
        return this.queryForExistence(queryString);
    }

    public boolean queryForExistence(String queryString) {
        boolean exists;
        try (Statement statement = this.connection.createStatement();
             ResultSet rs = this.executeQuery(queryString, statement);){
            exists = rs.next();
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        return exists;
    }

    public List<String> getStrings(QueryTemplate query, String fieldName) {
        StringCreator creator = new StringCreator(fieldName);
        return this.getRecords(query, creator);
    }

    public int queryForInt(QueryTemplate query) throws DataNotFoundException {
        return this.queryForInt(query.toString());
    }

    public int queryForInt(String query) throws DataNotFoundException {
        int num;
        block16: {
            try (Statement statement = this.connection.createStatement();
                 ResultSet rs = this.executeQuery(query, statement);){
                if (rs.next()) {
                    num = rs.getInt(1);
                    if (rs.next()) {
                        throw new DataAccessException("too many rows for: " + query);
                    }
                    break block16;
                }
                throw new DataNotFoundException(query);
            }
            catch (SQLException e) {
                throw new DataAccessException(e);
            }
        }
        return num;
    }

    public double queryForDouble(QueryTemplate query) throws DataNotFoundException {
        double result;
        block16: {
            try (Statement statement = this.connection.createStatement();
                 ResultSet rs = this.executeQuery(query, statement);){
                if (rs.next()) {
                    result = rs.getDouble(1);
                    if (rs.next()) {
                        throw new DataAccessException("too many rows for: " + query.toString());
                    }
                    break block16;
                }
                throw new DataNotFoundException(query.toString());
            }
            catch (SQLException e) {
                throw new DataAccessException(e);
            }
        }
        return result;
    }

    public <K, T extends KeyRecord<K>> Map<K, T> getMap(QueryTemplate query, RecordCreator<T> creator) {
        LinkedHashMap map = new LinkedHashMap();
        return this.buildMap(map, query, creator);
    }

    /*
     * Exception decompiling
     */
    public <K, T> Map<K, T> buildMap(Map<K, T> map, QueryTemplate query, RecordCreator<T> creator, KeyExtractor<K, T> extractor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <K, T extends KeyRecord<K>> Map<K, T> buildMap(Map<K, T> map, QueryTemplate query, RecordCreator<T> creator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <K, T extends KeyRecord<K>> SafeMap<K, T> buildMap(SafeMap<K, T> map, QueryTemplate query, RecordCreator<T> creator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, V extends KeyRecord<K>, A> void buildClassifier(RecordClassifier<K, V, A> classifier, QueryTemplate query, RecordCreator<? extends V> creator) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        try (Statement statement = this.connection.createStatement(1004, 1008);
             ResultSet rs = this.executeQuery(query, statement);){
            long count = 0L;
            while (rs.next()) {
                try {
                    KeyRecord record = (KeyRecord)creator.createRecord(rs);
                    if (record != null) {
                        classifier.add(record);
                    }
                    if (++count % 10000L != 0L) continue;
                    logger.info("connection manager " + count);
                }
                catch (SQLException exc) {
                    ConnectionManager.logSQLExceptionData(exc, rs);
                    throw exc;
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    public <T> List<T> getRecords(String query, RecordCreator<T> creator, int limit) {
        ArrayList list = new ArrayList();
        this.addRecords(query, creator, list, limit);
        return list;
    }

    public <T> List<T> getRecords(String query, RecordCreator<T> creator) {
        ArrayList list = new ArrayList();
        this.addRecords(query, creator, list, Integer.MAX_VALUE);
        return list;
    }

    public <T> Set<T> getSet(String query, RecordCreator<T> creator, int limit) {
        LinkedHashSet set = new LinkedHashSet();
        this.addRecords(query, creator, set, limit);
        return set;
    }

    public <T> Set<T> getSet(String query, RecordCreator<T> creator) {
        LinkedHashSet set = new LinkedHashSet();
        this.addRecords(query, creator, set, Integer.MAX_VALUE);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addRecords(String query, RecordCreator<T> creator, Collection<T> list, int limit) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        long start = System.currentTimeMillis();
        try (Statement statement = this.connection.createStatement(1004, 1008);
             ResultSet rs = this.executeQuery(query, statement);){
            long time = System.currentTimeMillis();
            logger.log(Level.FINE, "statement: " + (time - start));
            start = time;
            try {
                time = System.currentTimeMillis();
                logger.log(Level.FINE, "execute: " + (time - start));
                start = time;
                while (rs.next() && list.size() < limit) {
                    try {
                        T record = creator.createRecord(rs);
                        if (record != null) {
                            list.add(record);
                        }
                        if (list.size() % 10000 != 0) continue;
                        logger.info("connection manager " + list.size() + "/" + limit);
                    }
                    catch (SQLException exc) {
                        ConnectionManager.logSQLExceptionData(exc, rs);
                        throw exc;
                    }
                }
                time = System.currentTimeMillis();
                logger.log(Level.FINE, "fetch: " + (time - start));
                start = time;
            }
            finally {
                time = System.currentTimeMillis();
                logger.log(Level.FINE, "close: " + (time - start));
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    public <T> List<T> getRecords(QueryTemplate query, RecordCreator<T> creator) {
        return this.getRecords(query.toString(), creator);
    }

    public <T> List<T> getRecords(QueryTemplate query, RecordCreator<T> creator, int limit) {
        return this.getRecords(query.toString(), creator, limit);
    }

    public <T> Set<T> getSet(QueryTemplate query, RecordCreator<T> creator) {
        String string = query.toString();
        return this.getSet(string, creator);
    }

    public <T> T getRecord(QueryTemplate template, RecordCreator<T> creator, String message, String key, int error) throws DataNotFoundException, MultipleRowException {
        String query = template.toString();
        return this.getRecord(query, creator, message, key, error, true);
    }

    public <T> T getRecord(String query, RecordCreator<T> creator, String message, String key, int error) throws DataNotFoundException, MultipleRowException {
        return this.getRecord(query, creator, message, key, error, true);
    }

    public <T> T getRecord(String query, RecordCreator<T> creator, String message, String key, int error, boolean checkUnique) throws DataNotFoundException, MultipleRowException {
        T record;
        block18: {
            try (Statement statement = this.connection.createStatement(1004, 1008);
                 ResultSet rs = this.executeQuery(query, statement);){
                if (rs.next()) {
                    try {
                        record = creator.createRecord(rs);
                    }
                    catch (SQLException exc) {
                        ConnectionManager.logSQLExceptionData(exc, rs);
                        throw exc;
                    }
                    if (checkUnique && rs.next()) {
                        throw new MultipleRowException("record non unico: " + query);
                    }
                    break block18;
                }
                throw new DataNotFoundException(message, key, error);
            }
            catch (SQLException e) {
                throw new DataAccessException(e);
            }
        }
        return record;
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator, String message, boolean checkUnique) throws DataNotFoundException, MultipleRowException {
        return this.getRecord(query, creator, message, null, checkUnique);
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator, String message, String key, boolean checkUnique) throws DataNotFoundException, MultipleRowException {
        String queryString = query.toString();
        return this.getRecord(queryString, creator, message, key, -1, checkUnique);
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator, String message, String key) throws DataNotFoundException, MultipleRowException {
        return this.getRecord(query, creator, message, key, true);
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    protected int getFieldMax(String tableName, String field) {
        return this.getMax("SELECT MAX(" + field + ") FROM " + tableName);
    }

    protected int getFieldMaxCondition(String tableName, String field, QueryTemplate condition) {
        return this.getFieldMaxCondition(tableName, field, condition.toString());
    }

    protected int getFieldMaxCondition(String tableName, String field, String condition) {
        return this.getMax("SELECT MAX(" + field + ") FROM " + tableName + " WHERE " + condition);
    }

    private int getMax(String query) {
        int max;
        try {
            max = this.queryForInt(query);
        }
        catch (DataNotFoundException e) {
            max = 0;
        }
        return max;
    }

    public void startTransaction() {
        this.setAutoCommit(false);
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            this.setAutoCommit(true);
        }
    }

    public static String loadTemplate(ClassLoader classLoader, String fileName) throws IOException {
        try (InputStream stream = classLoader.getResourceAsStream(fileName);){
            if (stream == null) {
                throw new FileNotFoundException(fileName);
            }
            String string = ConnectionManager.loadTemplate(stream);
            return string;
        }
    }

    public static String loadTemplate(InputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(stream);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                builder.append(line + " ");
            }
        }
        return builder.toString();
    }

    public static void logSQLExceptionData(SQLException exc, ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        StringBuilder build = new StringBuilder();
        String excString = exc.toString();
        build.append(excString);
        build.append(" : |");
        for (int column = 1; column <= columnCount; ++column) {
            build.append(rs.getString(column)).append("|");
        }
        Logger logger = Logger.getLogger(ConnectionManager.class.getName());
        String rsString = build.toString();
        logger.log(Level.SEVERE, rsString);
    }

    public boolean multiUpdate(MultiUpdateHandler handler) throws BatchUpdateException, SQLException, UnrecoverableException {
        boolean ok = false;
        try {
            this.startTransaction();
            handler.executeMultiUpdate();
            this.commit();
            ok = true;
        }
        finally {
            if (!ok) {
                this.rollback();
            }
        }
        return ok;
    }

    public boolean executeMultiUpdate(MultiUpdateHandler updateHandler, MultiExceptionHandler exceptionHandler) {
        boolean ok;
        try {
            ok = this.multiUpdate(updateHandler);
        }
        catch (BatchUpdateException exc) {
            SQLException e = exc.getNextException();
            do {
                exceptionHandler.handle(e);
            } while ((e = e.getNextException()) != null);
            exceptionHandler.handle(exc);
            ok = false;
        }
        catch (SQLException | UnrecoverableException exc) {
            exceptionHandler.handle(exc);
            ok = false;
        }
        return ok;
    }
}

